NEW 
10   REM *********************************************************
20   REM * PROGRAM NAME: LCD2.BAS                                *
30   REM * THIS PROGRAM IS WRITTEN FOR NMIX/T-0020 BOARD.        *
40   REM * PROGRAM READS THE INPUT FROM THE KEYBOARD OR KEYPAD   *
50   REM *   THEN DISPLAY (ASCII) CHARACTERS ON LCD. IT  ALSO,   *
60   REM *   DEMONSTRATES THE USE OF 'ESAVE' COMMAND TO SAVE     *
70   REM *   PROGRAM IN THE EXTERNAL EEPROM,  AND 'AUTOEE'       *
80   REM *   COMMAND TO AUTOSTART THE PROGRAM WHEN POWER UP OR   *
90   REM *   EVERY TIME THE RESET SWITCH IS PUSH.                *
100  REM * NOTE: BEFORE DOWN LOAD THIS PROGRAM, MAKE SURE THE    *
110  REM *       8K EEPROM IS INSTALLED ON THE MIDDLE SOCKET(U3) *
120  REM *       AND CONNECTS WIRE FOR CHIP SELECT AT $8000 ON   *
130  REM *       JUMPER BLOCK 'C'( PLEASE SEE THE DIAGRAM SHEET, *
140  REM *       'JUMPER FOR 8K BASIC' ).                        *
150  REM *   *** TO DISABLE THE AUTOSTART, GET BACK TO THE MAIN  *
160  REM *       MENU SELECTS [3] TO QUIT, THEN TYPE 'NOAUTO'.   *
170  REM *       REMEMBER, YOUR PROGRAM IS STILL SAVE IN THE     *
180  REM *       EXTERNAL EEPROM UNTIL THE NEXT PROGRAM IS SAVED.*
190  REM *********************************************************        
200  PRINT : T=15
1000 PRINT TAB(T), "*****************************************"
1010 PRINT TAB(T), "*        NMIX/T-0020 MENU               *"
1020 PRINT TAB(T), "*                                       *"     
1030 PRINT TAB(T), "*   PLEASE SELECT A NUMBER BELOW:       *"
1040 PRINT TAB(T), "*        [1] KEYBOARD INPUT             *"
1050 PRINT TAB(T), "*        [2] KEYPAD INPUT               *"
1060 PRINT TAB(T), "*        [3] EXIT                       *"
1070 PRINT TAB(T), "*****************************************"
1080 INPUT "ENTER A NUMBER, THEN PRESS <ENTER>: >>",N
1090 ON N GOSUB 2000, 3000, 1120
1100 PRINT : PRINT
1110 GOTO 1000
1120 PRINT : PRINT  TAB(20)," ___HAVE A NICE DAY!___ "
1999 END
2000 REM *********************************************************
2010 REM * READS CHARACTER FROM THE KEYBOARD AND DISPLAY ON LCD  *
2020 REM *********************************************************
2030 POKE($B5FC,$38) : REM CLEAR LCD, SET CURSOR ON
2040 POKE($B5FC,$E)
2050 POKE($B5FC,$1)
2060 PRINT : PRINT "ECHOS KEYBOARD INPUT ON LCD..."
2070 PRINT "TO GET BACK TO THE MAIN MENU, PRESS [CTRL+X]"
2080 INBYTE CH
2090 IF CH=$18 THEN 2200 ELSE 2100 : REM CHECK FOR [CTRL+X] KEYS ?
2100 IF CH=$8 THEN 2140 ELSE 2110  : REM CHECK FOR BACKSPACE KEY ?
2110 IF CH=$D THEN 2120 ELSE 2180  : REM CHECK FOR CR KEY ? 
2120 POKE($B5FC,$C0)  : REM SET CURSOR TO NEW LINE
2130 GOTO 2190
2140 POKE($B5FC,$10)  : REM BACK A SPACE AND DELETE A CHARACTER
2150 POKE($B5FD,$20)
2160 POKE($B5FC,$10)
2170 GOTO 2190
2180 POKE($B5FD,CH)   : REM DISPLAY ASCII CHARACTER ON LCD
2190 GOTO 2080
2200 RETURN
3000 REM *********************************************************
3010 REM *   READS KEYPAD KEYS AND DISPLAY CHARACTERS ON LCD     *
3020 REM *********************************************************
3030 POKE($B5FC,$38) : REM CLEAR LCD, SET CURSOR ON
3040 POKE($B5FC,$E)
3050 POKE($B5FC,$1)
3060 PRINT : PRINT "PRESS KEYPAD KEYS TO DISPLAY CHARACTERS";
3070 PRINT " (0 - 9, A - J) ON LCD..."
3080 PRINT "BACK TO THE MAIN MENU, PRESS ON 'J' KEY (KEYPAD'S KEY)."
3090 IF PEEK($B000).AND.1 THEN 3100 ELSE 3180 : REM IS PA0 HIGH?
3100 X=PEEK($B00A)/8                          : REM READ PORT-E
3110 IF X>9 THEN 3120 ELSE 3140    : REM CONVERTS TO ASCII VALUES
3120 X=X+55                        
3130 GOTO 3150
3140 X=X+48
3150 POKE($B5FD,X)                 : REM DISPLAY ON LCD 
3160 IF X=74 THEN 3190 ELSE 3170
3170 FOR I=1 TO 2000 : NEXT I      : REM DELAY
3180 GOTO 3090
3190 RETURN
4000 REM   (IF AUTOSTART IS USED, YOU MUST DECLARE 'AUTOEE' FIRST
4010 REM     THEN 'ESAVE' AFTER. IT WILL TAKE ABOUT 40 SECONDS TO
4020 REM     SAVE THIS PROGRAM. LINE #s ARE NOT NEEDED FOR AUTOEE
4030 REM     AND ESAVE COMMANDS)
AUTOEE
ESAVE
