NEW
01  REM ***********************************************************
02  REM * PROGRAM NAME: SPCL0102.BAS                              *
03  REM * DESCRIPTION: THIS IS A SAMPLE A/D PROGRAM FOR SPCL-0102.* 
04  REM *              PROGRAM READS THE ANALOG INPUTS, CONVERTS  *
05  REM *              TO DIGITAL & DISPLAYS THE READINDS.        *
06  REM ***********************************************************
10  REM ----- DATA INPUT CHANNELS ----
20  REM ASSIGNS DATA FOR CHANNELS 0,1,2,3,4,5,6,7
30  DATA 7,6,5,4,11,10,9,8 
40  REM --- CONVERTS A/D & DISPLAYS 8 CHANNEL READINGS IN HEXIDECIMAL ---
50  PRINT " CH0    CH1     CH2     CH3     CH4     CH5     CH6     CH7"
60  PRINT " ~~~    ~~~     ~~~     ~~~     ~~~     ~~~     ~~~     ~~~"
80  DIM CH(7)
90  FOR I=0 TO  7
100  READ CH(I)
110  NEXT I
120  FOR N=0 TO 7
130 POKE($B5F8,CH(N))         :  REM SELECTS A CHANNEL  
140 POKE($B5FA,0)             :  REM INIT 12-BIT A/D CONVERSION 
150 FOR DL=1 TO 100 : NEXT DL :  REM DELAY
160 HB=PEEK($B5FA)*256        :  REM READS HIGH BYTE
170 LB=PEEK($B5FB)            :  REM READS LOW BYTE
180 AD=((HB+LB)/16).AND.$FFF  :  REM COMBINES & PRODUCES 12-BIT
190 PRINT HEX(AD)," ";        :  REM PRINTS HEXIDECIMAL RESULTS
200 NEXT N
210 FOR J=1 TO 2000 : NEXT J
220 PRINT CHR$(13);
230 GOTO 120
299 END
